//
//  GHFileInfoData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 4/13/18.
//  Copyright © 2018 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  Object containing the contents of the data file as retrieved from the Garmin device.
 */
@interface GHFileInfoData : NSObject

/**
 *  The contents of the file. This data can be processed using the FIT SDK.
 */
@property (nonatomic) NSData *fileData;

/**
 *  The file creation time.
 */
@property (nonatomic) NSDate *startTimestamp;

/**
 *  The time of the last record in the file.
 */
@property (nonatomic) NSDate *endTimestamp;


@end
